<?php
/**
 * Background Mask Style - Diagonal.
 *
 * @package Divi
 * @sub-package Builder
 * @since 4.15.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

/**
 * Class ET_Builder_Mask_Diagonal
 *
 * @since 4.15.0
 */
class ET_Builder_Mask_Diagonal extends ET_Builder_Background_Mask_Style_Base {
	/**
	 * Configuration.
	 *
	 * @return array
	 */
	public function settings() {
		return array(
			'label'      => esc_html__( 'Diagonal', 'et-builder' ),
			'svgContent' => array(
				'default'          => array(
					'landscape' => '<path d="M0,1440H1920V0H0Zm1023.07-137.75,307.2-1187.92A85.83,85.83,0,0,1,1413.36,50h384.43A72.21,72.21,0,0,1,1870,122.21V1317.79a72.21,72.21,0,0,1-72.21,72.21H1091A70.18,70.18,0,0,1,1023.07,1302.25Z"/>',
					'portrait'  => '<path d="M0,0V2560H1920V0ZM1870,2437.79a72.21,72.21,0,0,1-72.21,72.21h-823a70.18,70.18,0,0,1-67.94-87.76L1503.73,114.33A85.83,85.83,0,0,1,1586.81,50h211A72.21,72.21,0,0,1,1870,122.21Z"/>',
					'square'    => '<path d="M0,1920H1920V0H0Zm970.41-137.75L1401.74,114.33A85.81,85.81,0,0,1,1484.82,50h313A72.21,72.21,0,0,1,1870,122.21V1797.79a72.21,72.21,0,0,1-72.21,72.21H1038.35A70.18,70.18,0,0,1,970.41,1782.25Z"/>',
				),
				'default-inverted' => array(
					'landscape' => '<path d="M1023.07,1302.25l307.2-1187.92A85.83,85.83,0,0,1,1413.36,50h384.43A72.21,72.21,0,0,1,1870,122.21V1317.79a72.21,72.21,0,0,1-72.21,72.21H1091A70.18,70.18,0,0,1,1023.07,1302.25Z"/>',
					'portrait'  => '<path d="M906.87,2422.24,1503.73,114.33A85.83,85.83,0,0,1,1586.81,50h211A72.21,72.21,0,0,1,1870,122.21V2437.79a72.21,72.21,0,0,1-72.21,72.21h-823A70.18,70.18,0,0,1,906.87,2422.24Z"/>',
					'square'    => '<path d="M970.41,1782.25,1401.74,114.33A85.81,85.81,0,0,1,1484.82,50h313A72.21,72.21,0,0,1,1870,122.21V1797.79a72.21,72.21,0,0,1-72.21,72.21H1038.35A70.18,70.18,0,0,1,970.41,1782.25Z"/>',
				),
				'rotated'          => array(
					'landscape' => '<path d="M1920,1440V0H0V1440ZM1782.25,949.59,114.33,518.26A85.81,85.81,0,0,1,50,435.18v-313A72.21,72.21,0,0,1,122.21,50H1797.79A72.21,72.21,0,0,1,1870,122.21V881.65A70.18,70.18,0,0,1,1782.25,949.59Z"/>',
					'portrait'  => '<path d="M1920,2560V0H0V2560ZM1782.25,1360.59,114.33,929.26A85.81,85.81,0,0,1,50,846.18v-724A72.21,72.21,0,0,1,122.21,50H1797.79A72.21,72.21,0,0,1,1870,122.21V1292.65A70.18,70.18,0,0,1,1782.25,1360.59Z"/>',
					'square'    => '<path d="M1920,1920V0H0V1920ZM1782.25,949.59,114.33,518.26A85.81,85.81,0,0,1,50,435.18v-313A72.21,72.21,0,0,1,122.21,50H1797.79A72.21,72.21,0,0,1,1870,122.21V881.65A70.18,70.18,0,0,1,1782.25,949.59Z"/>',
				),
				'rotated-inverted' => array(
					'landscape' => '<path d="M1782.25,949.59,114.33,518.26A85.81,85.81,0,0,1,50,435.18v-313A72.21,72.21,0,0,1,122.21,50H1797.79A72.21,72.21,0,0,1,1870,122.21V881.65A70.18,70.18,0,0,1,1782.25,949.59Z"/>',
					'portrait'  => '<path d="M1782.25,1360.59,114.33,929.26A85.81,85.81,0,0,1,50,846.18v-724A72.21,72.21,0,0,1,122.21,50H1797.79A72.21,72.21,0,0,1,1870,122.21V1292.65A70.18,70.18,0,0,1,1782.25,1360.59Z"/>',
					'square'    => '<path d="M1782.25,949.59,114.33,518.26A85.81,85.81,0,0,1,50,435.18v-313A72.21,72.21,0,0,1,122.21,50H1797.79A72.21,72.21,0,0,1,1870,122.21V881.65A70.18,70.18,0,0,1,1782.25,949.59Z"/>',
				),
			),
		);
	}
}

return new ET_Builder_Mask_Diagonal();
