// This script is loaded both on the frontend page and in the Visual Builder.

jQuery(function ($) {
	$('.dbp_divi_background_plus, .dbp_fullwidth_divi_background_plus').each(function () {

		var $module = $(this);
		var level = $(this).find('*[data-level]').data('level');

		if (level === 'column') {
			var $parent = $module.parents('.et_pb_column');
		}
		else if (level === 'row') {
			var $parent = $module.parents('.et_pb_row');
		}
		else if (level === 'fullwidth-section') {
			var $parent = $module.parents('.et_pb_fullwidth_section');
		}
		else {
			var $parent = $module.parents('.et_pb_section');
		}

		$parent.children('.dbp_divi_background_plus_moved').remove();

		if ($parent.children('.et_pb_section_video_bg').length) {
			$module.insertAfter($parent.children('.et_pb_section_video_bg').last());
		}
		else if ($parent.children('.et_parallax_bg_wrap').length) {
			$module.insertAfter($parent.children('.et_parallax_bg_wrap').last());
		}
		else {
			$module.prependTo($parent);
		}


		$module.removeClass('dbp_divi_background_plus').addClass('dbp_divi_background_plus_moved');
		$module.removeClass('dbp_fullwidth_divi_background_plus').addClass('dbp_divi_background_plus_moved');
	});
});