<?php

class FDBP_Module extends ET_Builder_Module {

	public $slug       = 'dbp_fullwidth_divi_background_plus';
	public $vb_support = 'on';
	public $fullwidth  = true;

	protected $module_credits = array(
		'module_uri' => 'https://besuperfly.com/product/divi-background-plus/',
		'author'     => 'BeSuperfly',
		'author_uri' => 'https://besuperfly.com/',
	);

	public function init() {
		$this->name = esc_html__( 'Fullwidth Divi Background Plus', 'dbp-divi-background-plus' );

        $this->settings_modal_toggles = array(
            'general'  => array(
                'toggles' => array(
                    'layout'     => esc_html__( 'Layout', 'dbp-divi-background-plus' ),
                ),
            )
        );
	}

	public function dequeue_frontend_bundle() {
	    wp_dequeue_script( "{$this->name}-frontend-bundle" );
	}

	public function get_fields() {
		$fields = array(
        );
        return $fields;
	}

	public function get_advanced_fields_config() {
		return array(
			'button'         => false,
			'filters'        => false,
			'text'		     => false,
			'fonts' 		 => false,
			'margin_padding' => false,
			'borders'        => false,
			'box_shadow'     => false
		);
	}

	public function render( $attrs, $content = null, $render_slug ) {
        return '<div class="dbp_divi_background_plus_inner" data-level="fullwidth-section">DB+</div>';
	}
}

new FDBP_Module;