// External Dependencies
import React, { Component, Fragment } from 'react';
import $ from 'jquery';

// Internal Dependencies
import './style.css';

class FullwidthDiviBackgroundPlus extends Component {

  static slug = 'dbp_fullwidth_divi_background_plus';

  componentDidMount() {
    this.renderDataContainer(false);
  }

  componentDidUpdate() {
    this.renderDataContainer(false);
  }

  componentWillUnmount() {
    this.renderDataContainer(true);
  }


  renderDataContainer(unmount) {
    var $dataContainer = $(this.refs.dataContainer);
    $dataContainer = $dataContainer.attr('level', 'fullwidth-section');
    var $module = $dataContainer.closest('.dbp_fullwidth_divi_background_plus'),
      $parent = $dataContainer.closest('.et_pb_fullwidth_section');

    console.log($module);


    // Remove old version
    var dbpSelectorArray = $module.attr('class').split(' ');

    dbpSelectorArray = $.grep(dbpSelectorArray, function (value, i) {
      if (value.indexOf('dbp_fullwidth_divi_background_plus_') !== -1) {
        return true;
      }
    });

    var dbpSelectorString = dbpSelectorArray.join('.');
    $('.dbp_divi_background_plus_moved.' + dbpSelectorString).remove();

    if (!unmount) {
      // Copy and move module   
      if ($parent.children('.et_pb_section_video_bg').length) {
        $module.clone().insertAfter($parent.children('.et_pb_section_video_bg')).removeClass('dbp_fullwidth_divi_background_plus').addClass('dbp_divi_background_plus_moved');
      }
      else if ($parent.children('.et_parallax_bg_wrap').length) {
        $module.clone().insertAfter($parent.children('.et_parallax_bg_wrap')).removeClass('dbp_fullwidth_divi_background_plus').addClass('dbp_divi_background_plus_moved');
      }
      else {
        $module.clone().prependTo($parent).removeClass('dbp_fullwidth_divi_background_plus').addClass('dbp_divi_background_plus_moved').find('.et-fb-mousetrap');
      }
    }
  }

  render() {
    return (
      <Fragment>
        <div className="dbp_fullwidth_divi_background_plus_inner" data-level="fullwidth-section" ref="dataContainer">Fullwidth Divi Background Plus</div>
      </Fragment>
    );
  }
}

export default FullwidthDiviBackgroundPlus;