<?php

class DBP_Module extends ET_Builder_Module {

	public $slug       = 'dbp_divi_background_plus';
	public $vb_support = 'on';

	protected $module_credits = array(
		'module_uri' => 'https://besuperfly.com/product/divi-background-plus/',
		'author'     => 'BeSuperfly',
		'author_uri' => 'https://besuperfly.com/',
	);

	public function init() {
		$this->name = esc_html__( 'Divi Background Plus', 'dbp-divi-background-plus' );

        $this->settings_modal_toggles = array(
            'general'  => array(
                'toggles' => array(
                    'layout'     => esc_html__( 'Layout', 'dbp-divi-background-plus' ),
                ),
            )
        );
	}

	public function dequeue_frontend_bundle() {
	    wp_dequeue_script( "{$this->name}-frontend-bundle" );
	}

	public function get_fields() {
		$fields = array(
            'level' => array(
                'label'             => esc_html__( 'Level', 'dbp-divi-background-plus' ),
                'type'              => 'select',
                'options'           => array(
                    'section' => esc_html__( 'Section', 'dbp-divi-background-plus' ),
                    'row' => esc_html__( 'Row', 'dbp-divi-background-plus' ),
                    'column' => esc_html__( 'Column', 'dbp-divi-background-plus' )
                ),
                'description'       => esc_html__( 'Choose what level to place the overlay.', 'dbp-divi-background-plus' ),
                'toggle_slug'     => 'layout',
            )
        );
        return $fields;
	}

	public function get_advanced_fields_config() {
		return array(
			'button'         => false,
			'filters'        => false,
			'text'		     => false,
			'fonts' 		 => false,
			'margin_padding' => false,
			'borders'        => false,
			'box_shadow'     => false
		);
	}

	public function render( $attrs, $content = null, $render_slug ) {
        return sprintf(
        	'<div class="dbp_divi_background_plus_inner" data-level="%1$s">DB+</div>',
        	$this->props['level']
        );
	}
}

new DBP_Module;