// External Dependencies
import React, { Component, Fragment } from 'react';
import $ from 'jquery';

// Internal Dependencies
import './style.css';

class DiviBackgroundPlus extends Component {

  static slug = 'dbp_divi_background_plus'; 
  
  componentDidMount() {
    this.renderDataContainer(false);
  }  

  componentDidUpdate() {
    this.renderDataContainer(false);
  }
  
  componentWillUnmount() {
    this.renderDataContainer(true);
  }
  

  renderDataContainer(unmount) {
    var $dataContainer = $(this.refs.dataContainer);
    $dataContainer.data('level', this.props.level);
    var $module = $dataContainer.closest('.dbp_divi_background_plus');
    var $parent;

    if(typeof this.props.level === 'undefined') {
      $parent = $dataContainer.closest('.et_pb_section');
    }
    else if(this.props.level === 'column') {
      $parent = $dataContainer.closest('.et_pb_column');
    }
    else if(this.props.level === 'row') {
      $parent = $dataContainer.closest('.et_pb_row');
    }
    else if(this.props.level === 'section') {
      $parent = $dataContainer.closest('.et_pb_section');
    }

    // Remove old version
    var dbpSelectorArray = $module.attr('class').split(' ');
    
    dbpSelectorArray = $.grep(dbpSelectorArray, function(value, i) {
      if(value.indexOf('dbp_divi_background_plus_') !== -1) {
        return true;
      }
    });
    
    var dbpSelectorString = dbpSelectorArray.join('.');
    $('.dbp_divi_background_plus_moved.' + dbpSelectorString).remove();

    if(!unmount) {
      // Copy and move module    
      if($parent.children('.et_pb_section_video_bg').length) {
        $module.clone().insertAfter($parent.children('.et_pb_section_video_bg')).removeClass('dbp_divi_background_plus').addClass('dbp_divi_background_plus_moved');
      }
      else if($parent.children('.et_parallax_bg_wrap').length) {
        $module.clone().insertAfter($parent.children('.et_parallax_bg_wrap')).removeClass('dbp_divi_background_plus').addClass('dbp_divi_background_plus_moved');
      }        
      else {
        $module.clone().prependTo($parent).removeClass('dbp_divi_background_plus').addClass('dbp_divi_background_plus_moved').find('.et-fb-mousetrap');
      }
    }
  }

  render() {
    return (
      <Fragment>
        <div className="dbp_divi_background_plus_inner" ref="dataContainer">Divi Background Plus</div>
      </Fragment>
    );
  }
}

export default DiviBackgroundPlus;